% Estimation of Calvo param. price in DSGE model cited from Handbook of
% Macroeconomics 2
clear all;
warning('off','all')
warning
% generate random errors and keep the seed, save the current generator settings in st:  
N_all=1000;
v_est_p2_inf=zeros(N_all,1);
v_est_p2_reg_inf=zeros(N_all,1);
v_est_p2_nonreg_inf=zeros(N_all,1);
v_est_p2_opt_reg_inf=zeros(N_all,1);
v_est_p2_opt_nonreg_inf=zeros(N_all,1);
v_est_p2=zeros(N_all,1);
v_est_p2_reg=zeros(N_all,1);
v_est_p2_nonreg=zeros(N_all,1);
v_est_p2_opt_reg=zeros(N_all,1);
v_est_p2_opt_nonreg=zeros(N_all,1);
N_pop=10;
Tt = 400;
% if fsample==1
% Tt=100;
% end
simdiscard=500;

Tsim = simdiscard + Tt;
trainingT = round(2/3*Tt);
ST = ceil(0.75*(Tt^(1/3))); %5,6
ST_training = ceil(0.75*(trainingT^(1/3))); %4,5
rn = rng;
for sim_index = 1 : N_all
SIMR(:,:,sim_index) = randn(Tsim,4); %4 shocks
end
lags = 4;
rng(rn);

CALI=0.65;%these values are calibrated to truth
% GRID=[0.1 0.2 0.3 0.4 0.5 0.65 0.7 0.8 0.9];
GRID=[0.05:0.05:0.95];
endj=length(GRID)+2; %*************************************************************number of grid values
grids=zeros(endj,1); % horizontal grid width
lbb=0.01;%bounds
ubb= 0.99  ;
grids(1,1)=lbb;
grids(endj,1)=ubb;

N=100;

p1_range = [0.05:0.05:0.95];
c_a = [0.1 0.05 0.01 0.005 0.001 0.0001 10^(-5) 10^(-6) 0];

global p h posR;
p=4;
h=80;
posR=4;
n_obs=4;

hs=1;
v_irf_analy = zeros(4, h-hs+1);
v_irf_analy_full = zeros(4, h-hs+1);
nfail=0;

for jj = 1:N_all
try
    [PSI_0, PSI_1, PHI_1, PHI_epsilon]=hdgp(CALI);
        % Simulate solution
        Ssim1 = zeros(Tsim,5);
        Ysim1 = zeros(Tsim,4);
        for tt = 2:Tsim;
            Ssim1(tt,:) = (PHI_1*Ssim1(tt-1,:)' + PHI_epsilon*SIMR(tt,:,jj)')';
            Ysim1(tt,:) = (PSI_0+PSI_1*Ssim1(tt,:)')';
        end
        
        % Discard initial 500, and keep sample equal samplesize for variables
        YYy = Ysim1(simdiscard+1:end,:);
        training = YYy(1:trainingT, :);
        testing = YYy(trainingT+1:Tt, :);
        
        [A,SIGMA,U,V] = olsvarc(training, p); %structural VAR(p) for training set
        [At,SIGMAt,Ut,Vt] = olsvarc(testing, p);%structural VAR(p) for testing set
        [Af,SIGMAf,Uf,Vf] = olsvarc(YYy, p);
        sampleirf_full = irfvar_single(Af,SIGMAf,p);
        sampleirf_full = vec(sampleirf_full);
        
        irf_star = zeros(4, (h+1), N);
        v_irf_star = zeros(4*(h+1), N);
        
        irf_star_1a = zeros(n_obs, (h+1), N);
        irf_star_1b = zeros(n_obs, (h+1), N);
        irf_star_2a = zeros(n_obs, (h+1), N);
        irf_star_2b = zeros(n_obs, (h+1), N);
        irf_star_3a = zeros(n_obs, (h+1), N);
        irf_star_3b = zeros(n_obs, (h+1), N);
        irf_star_4a = zeros(n_obs, (h+1), N);
        irf_star_4b = zeros(n_obs, (h+1), N);
        irf_star_5a = zeros(n_obs, (h+1), N);
        irf_star_5b = zeros(n_obs, (h+1), N);
        for n = 1:N
            [IRFii IRFii_ST]=bootirf_single_opt(A,U,training,V,ST_training);
            irf_star(:, :, n) = IRFii;
            v_irf_star(:, n) = vec(IRFii);
            irf_star_1a(:,:,n) = IRFii_ST(:,:,1);
            irf_star_1b(:,:,n) = IRFii_ST(:,:,2);
            irf_star_2a(:,:,n) = IRFii_ST(:,:,3);
            irf_star_2b(:,:,n) = IRFii_ST(:,:,4);
            irf_star_3a(:,:,n) = IRFii_ST(:,:,5);
            irf_star_3b(:,:,n) = IRFii_ST(:,:,6);
            irf_star_4a(:,:,n) = IRFii_ST(:,:,7);
            irf_star_4b(:,:,n) = IRFii_ST(:,:,8);
            irf_star_5a(:,:,n) = IRFii_ST(:,:,9);
            irf_star_5b(:,:,n) = IRFii_ST(:,:,10);
            v_irf_star(:, n) = vec(IRFii);
        end
        mean_irf_star = mean(v_irf_star, 2);
        demean_irf_star = irf_star-mean(irf_star,3);
        demean_irf_star_1a = irf_star_1a-mean(irf_star_1a,3);
        demean_irf_star_1b = irf_star_1b-mean(irf_star_1b,3);
        demean_irf_star_2a = irf_star_2a-mean(irf_star_2a,3);
        demean_irf_star_2b = irf_star_2b-mean(irf_star_2b,3);
        demean_irf_star_3a = irf_star_3a-mean(irf_star_3a,3);
        demean_irf_star_3b = irf_star_3b-mean(irf_star_3b,3);
        demean_irf_star_4a = irf_star_4a-mean(irf_star_4a,3);
        demean_irf_star_4b = irf_star_4b-mean(irf_star_4b,3);
        demean_irf_star_5a = irf_star_5a-mean(irf_star_5a,3);
        demean_irf_star_5b = irf_star_5b-mean(irf_star_5b,3);
        Cm = zeros(N, N);
        Cm_opt = zeros(N, N);  
        for b = 1:N
            for bprime = 1:N
                Cbb = 0;
                Cbb_opt = 0;
                for ss = hs: h
                    Cbb = Cbb + demean_irf_star(:, ss+1, b)'* demean_irf_star(:, ss+1, bprime)/N;
                    Cbb_opt = Cbb_opt...
                    + (demean_irf_star(:, ss+1, b)'* demean_irf_star(:, ss+1, bprime)...
                    + 2*((1-1/ST_training)*demean_irf_star_1a(:,ss+1,b)'*demean_irf_star_1b(:,ss+1,bprime)...
                        +(1-2/ST_training)*demean_irf_star_2a(:,ss+1,b)'*demean_irf_star_2b(:,ss+1,bprime)...
                        +(1-3/ST_training)*demean_irf_star_3a(:,ss+1,b)'*demean_irf_star_3b(:,ss+1,bprime)...
                        +(1-4/ST_training)*demean_irf_star_4a(:,ss+1,b)'*demean_irf_star_4b(:,ss+1,bprime)...
                        +(1-5/ST_training)*demean_irf_star_5a(:,ss+1,b)'*demean_irf_star_5b(:,ss+1,bprime)))/N;
                end
                Cm(b, bprime) = Cbb;
                Cm_opt(b, bprime) = Cbb_opt;
            end
        end
        [Beta lambda] = eig(Cm);
        [Beta_opt lambda_opt] = eig(Cm_opt); 
        psi = v_irf_star((4*hs + 1):4*(h+1), :) - mean_irf_star((4*hs+1):4*(h+1));
        phi = psi * Beta/N;
        phi = (phi'./sqrt(diag(phi' * phi)))';
        
        psi_opt = demean_irf_star+2*((1-1/ST_training)*demean_irf_star_1a...
                            +(1-2/ST_training)*demean_irf_star_2a...
                            +(1-3/ST_training)*demean_irf_star_3a...
                            +(1-4/ST_training)*demean_irf_star_4a...
                            +(1-5/ST_training)*demean_irf_star_5a);
        psi_opt = reshape(psi_opt, n_obs*(h+1), N);
        psi_opt = psi_opt((n_obs*hs + 1):n_obs*(h+1), :);
        phi_opt = psi_opt * Beta_opt/N;
        % normalize phi
        phi_opt = (phi_opt'./sqrt(diag(phi_opt' * phi_opt)))';
%*******estimation by simulation*******
    irfs = zeros(4*(h+1), endj);
    for j=1:endj
%        rejct=0;
    if j== 1
        zeta_p     = lbb;
    elseif j== endj
        zeta_p     = ubb;
    else
        zeta_p     =   GRID(j-1); %changing Null value of zeta_p
    end
    grids(j,1)=zeta_p;
    grids(endj,1)=ubb; 
    [PSI_0, PSI_1, PHI_1, PHI_epsilon]=hdgp(zeta_p);

    m_irf_path = zeros(4*(h+1), N_pop);
    for j2 = 1:N_pop
        % Simulate solution
        Ssim2 = zeros(Tsim,5);
        Ysim2 = zeros(Tsim,4);
        for tt = 2:Tsim;
            Ssim2(tt,:) = (PHI_1*Ssim2(tt-1,:)' + PHI_epsilon*randn(1,4)')';
            Ysim2(tt,:) = (PSI_0+PSI_1*Ssim2(tt,:)')';
        end
        % Discard initial 500, and keep sample equal samplesize for variables
        Ymc = Ysim2(simdiscard+1:end,:);
        simdata = Ymc(1:trainingT, :);
        [Apath,SIGMApath,Upath,Vpath] = olsvarc(simdata, p);
        [IRFr]=bootirf_single(Apath,U,training,Vpath); % 4 by 21
        irf_path = vec(IRFr);
        m_irf_path(:, j2) = irf_path;
    end
    mean_irf = mean(m_irf_path, 2);
    irfs(:, j) = mean_irf;
    end
    for hh = hs:h
        v_irf_analy(:,hh)=PSI_1*(PHI_1)^(hh)*PHI_epsilon(:,4);
    end
    irf_analy = vec(v_irf_analy);
    dis=irfs((4*hs+1):4*(h+1), :) - irf_analy;
    %dis_sqr=sum(irfs(5:4*h, :).^2, 1);
    
    reg_a = c_a./(trainingT^(1/3));
    v_obj = zeros(endj,1);
    v_d_sqr_1 = zeros(length(reg_a), 1);
    v_obj_opt = zeros(endj,1);
    v_d_sqr_2 = zeros(length(reg_a), 1);
    
    for aa = 1:length(reg_a)
        for n_p = 1:endj
            reg_dis = dis(:, n_p);
            reg_sqr = (phi' * reg_dis).^2; % T by 1 vector
            obj = (diag(lambda)./(diag(lambda).^2 + reg_a(aa)))' * reg_sqr;
            v_obj(n_p) = obj;
            reg_sqr_opt = (phi_opt' * reg_dis).^2; % T by 1 vector
            obj_opt = (diag(lambda_opt)./(diag(lambda_opt).^2 + reg_a(aa)))' * reg_sqr_opt;
            v_obj_opt(n_p) = obj_opt;
        %end
        end
%diagonal SMAS        
        p_temp_loc = find(v_obj == min(v_obj));
        est_zetap_temp = grids(p_temp_loc);
        
%%%%% testing set %%%%%
        [PSI_0, PSI_1, PHI_1, PHI_epsilon]=hdgp(est_zetap_temp);
        v_irf_analy_test=zeros(4,h-hs+1);
        for hh = hs:h
            v_irf_analy_test(:,hh)=PSI_1*(PHI_1)^(hh)*PHI_epsilon(:,4);
        end
        irf_analy_test = vec(v_irf_analy_test);
    
        Ssim3 = zeros(Tsim,5);
        Ysim3 = zeros(Tsim,4);
        for tt = 2:Tsim;
            Ssim3(tt,:) = (PHI_1*Ssim3(tt-1,:)' + PHI_epsilon*randn(1,4)')';
            Ysim3(tt,:) = (PSI_0+PSI_1*Ssim3(tt,:)')';
        end
        % Discard initial 500, and keep sample equal samplesize for variables
        Ymc_test = Ysim3(simdiscard+1:end,:);
        simtesting = Ymc_test(trainingT+1:Tt,:);
        [Atest,SIGMAtest,Utest,Vtest] = olsvarc(simtesting, p);
            
        m_irf_testing_1 = zeros(4*(h+1), 10);
            
        for tt = 1:10
            [IRFt1]=bootirf_single(Atest,Ut,testing,Vtest);
            m_irf_testing_1(:, tt) = vec(IRFt1);
        end

        mean_irf_testing_1 = mean(m_irf_testing_1,2);
        d_sqr_1 = (mean_irf_testing_1((4*hs+1):4*(h+1))-irf_analy_test)'...
            *(mean_irf_testing_1((4*hs+1):4*(h+1))-irf_analy_test);
        v_d_sqr_1(aa) = d_sqr_1;

%optimal SMAS        
        p_temp_loc = find(v_obj_opt == min(v_obj_opt));
        est_zetap_temp = grids(p_temp_loc);
        
%%%%% testing set %%%%%
        [PSI_0, PSI_1, PHI_1, PHI_epsilon]=hdgp(est_zetap_temp);
        v_irf_analy_test=zeros(4,h-hs+1);
        for hh = hs:h
            v_irf_analy_test(:,hh)=PSI_1*(PHI_1)^(hh)*PHI_epsilon(:,4);
        end
        irf_analy_test = vec(v_irf_analy_test);
    
        Ssim3 = zeros(Tsim,5);
        Ysim3 = zeros(Tsim,4);
        for tt = 2:Tsim;
            Ssim3(tt,:) = (PHI_1*Ssim3(tt-1,:)' + PHI_epsilon*randn(1,4)')';
            Ysim3(tt,:) = (PSI_0+PSI_1*Ssim3(tt,:)')';
        end
        % Discard initial 500, and keep sample equal samplesize for variables
        Ymc_test = Ysim3(simdiscard+1:end,:);
        simtesting = Ymc_test(trainingT+1:Tt,:);
        [Atest,SIGMAtest,Utest,Vtest] = olsvarc(simtesting, p);
            
        m_irf_testing_1 = zeros(4*(h+1), 10);
            
        for tt = 1:10
            [IRFt1]=bootirf_single(Atest,Ut,testing,Vtest);
            m_irf_testing_1(:, tt) = vec(IRFt1);
        end

        mean_irf_testing_1 = mean(m_irf_testing_1,2);
        d_sqr_2 = (mean_irf_testing_1((4*hs+1):4*(h+1))-irf_analy_test)'...
            *(mean_irf_testing_1((4*hs+1):4*(h+1))-irf_analy_test);
        v_d_sqr_2(aa) = d_sqr_2;
    end
    pick_c_1 = c_a(find(v_d_sqr_1 == min(v_d_sqr_1)));
    pick_c_2 = c_a(find(v_d_sqr_2 == min(v_d_sqr_2)));
    v_pick_c_1(jj) = pick_c_1;
    v_pick_c_2(jj) = pick_c_2;
    
    [Af,SIGMAf,Uf,Vf] = olsvarc(YYy, p);
    irf_star_full = zeros(4, (h+1), N);
    v_irf_star_full = zeros(4*(h+1), N);
    irf_star_full_1a = zeros(n_obs, (h+1), N);
    irf_star_full_1b = zeros(n_obs, (h+1), N);
    irf_star_full_2a = zeros(n_obs, (h+1), N);
    irf_star_full_2b = zeros(n_obs, (h+1), N);
    irf_star_full_3a = zeros(n_obs, (h+1), N);
    irf_star_full_3b = zeros(n_obs, (h+1), N);
    irf_star_full_4a = zeros(n_obs, (h+1), N);
    irf_star_full_4b = zeros(n_obs, (h+1), N);
    irf_star_full_5a = zeros(n_obs, (h+1), N);
    irf_star_full_5b = zeros(n_obs, (h+1), N);
    
    for n = 1:N
        [IRFfull IRFfull_ST]=bootirf_single_opt(Af,Uf,YYy,Vf,ST);
        irf_star_full(:, :, n) = IRFfull;% store the values
        v_irf_star_full(:, n) = vec(IRFfull);
        irf_star_full_1a(:,:,n) = IRFfull_ST(:,:,1);
        irf_star_full_1b(:,:,n) = IRFfull_ST(:,:,2);
        irf_star_full_2a(:,:,n) = IRFfull_ST(:,:,3);
        irf_star_full_2b(:,:,n) = IRFfull_ST(:,:,4);
        irf_star_full_3a(:,:,n) = IRFfull_ST(:,:,5);
        irf_star_full_3b(:,:,n) = IRFfull_ST(:,:,6);
        irf_star_full_4a(:,:,n) = IRFfull_ST(:,:,7);
        irf_star_full_4b(:,:,n) = IRFfull_ST(:,:,8);
        irf_star_full_5a(:,:,n) = IRFfull_ST(:,:,9);
        irf_star_full_5b(:,:,n) = IRFfull_ST(:,:,10);
        irf_star_full_6a(:,:,n) = IRFfull_ST(:,:,11);
        irf_star_full_6b(:,:,n) = IRFfull_ST(:,:,12);
    end
    
    mean_irf_star_full = mean(v_irf_star_full, 2); % calculate the mean of irf from N paths
    demean_irf_star_full = irf_star_full-mean(irf_star_full,3);
    demean_irf_star_full_1a = irf_star_full_1a-mean(irf_star_full_1a,3);
    demean_irf_star_full_1b = irf_star_full_1b-mean(irf_star_full_1b,3);
    demean_irf_star_full_2a = irf_star_full_2a-mean(irf_star_full_2a,3);
    demean_irf_star_full_2b = irf_star_full_2b-mean(irf_star_full_2b,3);
    demean_irf_star_full_3a = irf_star_full_3a-mean(irf_star_full_3a,3);
    demean_irf_star_full_3b = irf_star_full_3b-mean(irf_star_full_3b,3);
    demean_irf_star_full_4a = irf_star_full_4a-mean(irf_star_full_4a,3);
    demean_irf_star_full_4b = irf_star_full_4b-mean(irf_star_full_4b,3);
    demean_irf_star_full_5a = irf_star_full_5a-mean(irf_star_full_5a,3);
    demean_irf_star_full_5b = irf_star_full_5b-mean(irf_star_full_5b,3);
    demean_irf_star_full_6a = irf_star_full_6a-mean(irf_star_full_6a,3);
    demean_irf_star_full_6b = irf_star_full_6b-mean(irf_star_full_6b,3);
    Cf = zeros(N, N);
    Cf_opt = zeros(N, N);    
    for b = 1:N
        for bprime = 1:N
            Cbb_f = 0;
            Cbb_f_opt = 0;
            for ss = hs: h
                Cbb_f = Cbb_f + demean_irf_star_full(:, ss+1, b)'* demean_irf_star_full(:, ss+1, bprime)/N;
                Cbb_f_opt = Cbb_f_opt...
                    + (demean_irf_star_full(:, ss+1, b)'* demean_irf_star_full(:, ss+1, bprime)...
                    + 2*((1-1/ST)*demean_irf_star_full_1a(:,ss+1,b)'*demean_irf_star_full_1b(:,ss+1,bprime)...
                        +(1-2/ST)*demean_irf_star_full_2a(:,ss+1,b)'*demean_irf_star_full_2b(:,ss+1,bprime)...
                        +(1-3/ST)*demean_irf_star_full_3a(:,ss+1,b)'*demean_irf_star_full_3b(:,ss+1,bprime)...
                        +(1-4/ST)*demean_irf_star_full_4a(:,ss+1,b)'*demean_irf_star_full_4b(:,ss+1,bprime)...
                        +(1-5/ST)*demean_irf_star_full_5a(:,ss+1,b)'*demean_irf_star_full_5b(:,ss+1,bprime)...
                        +(1-5/ST)*demean_irf_star_full_6a(:,ss+1,b)'*demean_irf_star_full_6b(:,ss+1,bprime)))/N;
            end
            Cf(b, bprime) = Cbb_f;
            Cf_opt(b, bprime) = Cbb_f_opt;
        end
    end
    
    [Beta_f lambda_f] = eig(Cf);
    [Beta_f_opt lambda_f_opt] = eig(Cf_opt);
    psi_f = v_irf_star_full((4*hs + 1):4*(h+1), :) - mean_irf_star_full((4*hs+1):4*(h+1));
    phi_f = psi_f * Beta_f/N;
    
    % normalize phi
    
    phi_f = (phi_f'./sqrt(diag(phi_f' * phi_f)))';
    psi_f_opt = demean_irf_star_full+2*((1-1/ST)*demean_irf_star_full_1a...
                            +(1-2/ST)*demean_irf_star_full_2a...
                            +(1-3/ST)*demean_irf_star_full_3a...
                            +(1-4/ST)*demean_irf_star_full_4a...
                            +(1-4/ST)*demean_irf_star_full_5a...
                            +(1-5/ST)*demean_irf_star_full_6a);
    psi_f_opt = reshape(psi_f_opt, n_obs*(h+1), N);
    psi_f_opt = psi_f_opt((n_obs*hs + 1):n_obs*(h+1), :);
    phi_f_opt = psi_f_opt * Beta_f_opt/N;
    % normalize phi
    phi_f_opt = (phi_f_opt'./sqrt(diag(phi_f_opt' * phi_f_opt)))';

    irfs_full = zeros(4*(h+1), endj);
    for j=1:endj
%        rejct=0;
    if j== 1
        zeta_p     = lbb;
    elseif j== endj
        zeta_p     = ubb;
    else
        zeta_p     =   GRID(j-1); %changing Null value of zeta_p
    end
    grids(j,1)=zeta_p;
    grids(endj,1)=ubb; 

    [PSI_0, PSI_1, PHI_1, PHI_epsilon]=hdgp(zeta_p);

    m_irf_path_f = zeros(4*(h+1), N_pop);
    for jf = 1:N_pop
        % Simulate solution
        Ssim4 = zeros(Tsim,5);
        Ysim4 = zeros(Tsim,4);
        for tt = 2:Tsim;
            Ssim4(tt,:) = (PHI_1*Ssim4(tt-1,:)' + PHI_epsilon*randn(1,4)')';
            Ysim4(tt,:) = (PSI_0+PSI_1*Ssim4(tt,:)')';
        end
        % Discard initial 500, and keep sample equal samplesize for variables
        Ymcf = Ysim4(simdiscard+1:end,:);
        simdataf = Ymcf;
        [Apathf,SIGMApathf,Upathf,Vpathf] = olsvarc(simdataf, p);
        [IRFr_full]=bootirf_single(Apathf,Uf,YYy,Vpathf);
        irf_path_full = vec(IRFr_full);
        m_irf_path_f(:, jf) = irf_path_full;
    end
    mean_irf_f = mean(m_irf_path_f, 2);
    irfs_full(:, j) = mean_irf_f;
    end
    
    for hh = hs:h
        v_irf_analy_full(:,hh)=PSI_1*(PHI_1)^(hh)*PHI_epsilon(:,4);
    end
    irf_analy_full = vec(v_irf_analy_full);
    
    dis_full_inf = irfs_full((4*hs+1):4*(h+1), :)-irf_analy_full; % dim: drop the first four responses
    dis_full_inf_sqr = sum(dis_full_inf.^2, 1);
    dis_full = sampleirf_full((4*hs+1):4*(h+1)) - irfs_full((4*hs+1):4*(h+1), :); % dim: drop the first four responses
    dis_full_sqr = sum(dis_full.^2, 1);

    p2_inf_loc = find(dis_full_inf_sqr == min(dis_full_inf_sqr));
    est_inf_p2 = grids(p2_inf_loc);
    p2_loc = find(dis_full_sqr == min(dis_full_sqr));
    est_p2 = grids(p2_loc);

    v_est_p2_inf(jj) = est_inf_p2;
    v_est_p2(jj) = est_p2;
    
    v_obj_1 = zeros(endj, 1);
    v_obj_2 = zeros(endj, 1);
    v_obj_3 = zeros(endj, 1);
    v_obj_4 = zeros(endj, 1);
    v_obj_5 = zeros(endj, 1);
    v_obj_6 = zeros(endj, 1);
    v_obj_7 = zeros(endj, 1);
    v_obj_8 = zeros(endj, 1);

    pick_reg_a_1 = pick_c_1/(Tt^(1/3));
    pick_reg_a_2 = pick_c_2/(Tt^(1/3));
    
    %for n_p1 = 1: length(p1_range)
    for n_p2 = 1: endj
        reg_dis_full_inf = dis_full_inf(:, n_p2);
        reg_sqr_full_inf = (phi_f' * reg_dis_full_inf).^2; % T by 1 vector
        obj_1 = (diag(lambda_f)./(diag(lambda_f).^2 + pick_reg_a_1))' * reg_sqr_full_inf;
        obj_2 = (diag(lambda_f)./(diag(lambda_f).^2))' * reg_sqr_full_inf;
        obj_3 = (diag(lambda_f_opt)./(diag(lambda_f_opt).^2 + pick_reg_a_2))' * reg_sqr_full_inf;
        obj_4 = (diag(lambda_f_opt)./(diag(lambda_f_opt).^2))' * reg_sqr_full_inf;
        
        reg_dis_full = dis_full(:, n_p2);
        reg_sqr_full = (phi_f' * reg_dis_full).^2; % T by 1 vector
        obj_5 = (diag(lambda_f)./(diag(lambda_f).^2 + pick_reg_a_1))' * reg_sqr_full;
        obj_6 = (diag(lambda_f)./(diag(lambda_f).^2))' * reg_sqr_full;
        obj_7 = (diag(lambda_f_opt)./(diag(lambda_f_opt).^2 + pick_reg_a_2))' * reg_sqr_full;
        obj_8 = (diag(lambda_f_opt)./(diag(lambda_f_opt).^2))' * reg_sqr_full;
        v_obj_1(n_p2) = obj_1;
        v_obj_2(n_p2) = obj_2;
        v_obj_3(n_p2) = obj_3;
        v_obj_4(n_p2) = obj_4;
        v_obj_5(n_p2) = obj_5;
        v_obj_6(n_p2) = obj_6;
        v_obj_7(n_p2) = obj_7;
        v_obj_8(n_p2) = obj_8;
    %end    
    end
    p2_reg_inf_loc = find(v_obj_1 == min(v_obj_1));
    p2_nonreg_inf_loc = find(v_obj_2 == min(v_obj_2));
    p2_opt_reg_inf_loc = find(v_obj_3 == min(v_obj_3));
    p2_opt_nonreg_inf_loc = find(v_obj_4 == min(v_obj_4));
    est_p2_reg_inf = grids(p2_reg_inf_loc)
    est_p2_nonreg_inf = grids(p2_nonreg_inf_loc)
    est_p2_opt_reg_inf = grids(p2_opt_reg_inf_loc)
    est_p2_opt_nonreg_inf = grids(p2_opt_nonreg_inf_loc);
    v_est_p2_reg_inf(jj) = est_p2_reg_inf;
    v_est_p2_nonreg_inf(jj) = est_p2_nonreg_inf;
    v_est_p2_opt_reg_inf(jj) = est_p2_opt_reg_inf;
    v_est_p2_opt_nonreg_inf(jj) = est_p2_opt_nonreg_inf;

    p2_reg_loc = find(v_obj_5 == min(v_obj_5));
    p2_nonreg_loc = find(v_obj_6 == min(v_obj_6));
    p2_opt_reg_loc = find(v_obj_7 == min(v_obj_7));
    p2_opt_nonreg_loc = find(v_obj_8 == min(v_obj_8));
    est_p2_reg = grids(p2_reg_loc)
    est_p2_nonreg = grids(p2_nonreg_loc)
    est_p2_opt_reg = grids(p2_opt_reg_loc)
    est_p2_opt_nonreg = grids(p2_opt_nonreg_loc)
    v_est_p2_reg(jj) = est_p2_reg;
    v_est_p2_nonreg(jj) = est_p2_nonreg;
    v_est_p2_opt_reg(jj) = est_p2_opt_reg;
    v_est_p2_opt_nonreg(jj) = est_p2_opt_nonreg;
catch
    nfail=nfail+1;
    disp(num2str(nfail))
end
end
save T400p4h80_infea_opt-2 v_est_p2_reg_inf v_est_p2_nonreg_inf...
    v_est_p2_opt_reg_inf v_est_p2_opt_nonreg_inf v_est_p2_reg...
    v_est_p2_nonreg v_est_p2_opt_reg v_est_p2_opt_nonreg...
    v_pick_c_1 v_pick_c_2